import { useDispatch } from "react-redux";
import * as SecureStore from "expo-secure-store";
import { login } from "../redux/slices/auth/signIn";
import { useEffect } from "react";
import { getPreferences } from "../redux/slices/preferences/getPreferences";
import { setLanguage } from "../redux/slices/language/language";
import i18n from "../src/language/i18n";

const useAuthCheck = () => {
    const dispatch = useDispatch();
    useEffect(() => {
        (async () => {
            try {
                // check application authentication
                const localAuth = await SecureStore.getItemAsync("isLoggedIn");
                if (localAuth) {
                    const auth = JSON.parse(localAuth);
                    if (auth?.access_token && auth?.user) {
                        dispatch(
                            login({
                                access_token: auth.access_token,
                                user: auth.user,
                            })
                        );
                    }
                };

                // set application language
                const langCode = await SecureStore.getItemAsync('languageCode');
                if(langCode == null) {
                    const res = await dispatch(getPreferences());
                    const { status, records } = res?.payload;
                    if (status?.code === 200) {
                        const { dflt_lang: lng } = records?.data?.company || {};
                        dispatch(setLanguage(lng));
                    }
                } else {
                    i18n.changeLanguage(langCode);
                    dispatch(setLanguage(langCode));
                }
            } catch (err) {}
        })()
    }, [dispatch]);
};

export default useAuthCheck;
